/*
** FCD basic routines
**
** 2000, 3/16 cut out from fcd.h
*/

#define FCD_BASIC_C
#include "fcd_basic.h"

MSF LBN_to_MSF(LBN in)
{
	MSF r;

	in += 150; /* pregap */
	
	r.f = in % 75;
	r.s = (in / 75) % 60;
	r.m = in / 75 / 60;
	r.padding = 0;

	return r;
}

LBN MSF_to_LBN(MSF in)
{
	LBN r;

	r = in.f;
	r += in.s * 75;
	r += in.m * 75 * 60;

	r -= 150; /* pregap */

	return r;
}
